function test_suite = testParens %#ok<STOUT>
initTestSuite;

function testNullInput %#ok<*DEFNU>
p = polysym;
out = callParens(p);
assertEqual(out.Value,'([])')

function testZeroCharInput
p = polysym('0');
out = callParens(p);
assertEqual(out.Value,'(0)')

function testZeroNumericInput
p = polysym(0);
out = callParens(p);
assertEqual(out.Value,'(0)')

function testCharInput
p = polysym('s');
out = callParens(p);
assertEqual(out.Value,'(s)');

function testDoublePrecisionInput
r = rand;
p = polysym(r);
out = callParens(p);
precision = floor(log10(r/eps(r)));
assertEqual(out.Value,['(',num2str(r,precision),')']);

function testSinglePrecisionInput
r = single(rand);
p = polysym(r);
out = callParens(p);
precision = floor(log10(r/eps(r)));
assertEqual(out.Value,['(',num2str(r,precision),')']);
